# Intuition
<!-- Describe your first thoughts on how to solve this problem. -->
Tried to solve by using permutations
( https://leetcode.com/problems/permutations/solutions/3851382/daily-02-08-23/ )
# Approach
<!-- Describe your approach to solving the problem. -->
Stored the first characters that will be generated by first digit of 'digits' string : then keep repeating the same fashion on rest of the characters present in 'digits' string


- I have considered all characters of the given digits as starting number one-by-one
- In next step include next digit which is in the digits string
- Keep iterating till our string reach the given digit size
- Add that way to answer
- Now step back and explore other numbers
- All this will happen recursively
---

Have a look at the code , still have any confusion then please let me know in the comments
Keep Solving.:)

> 
Unitary/Iterative Approach : https://leetcode.com/problems/letter-combinations-of-a-phone-number/solutions/3857796/iterative-approach-daily-03-08-23/ ---


# Complexity
- Time complexity : $$O(n*4^n)$$
<!-- Add your time complexity here, e.g. $$O(n)$$ -->

- Space complexity : $$O(4^n)$$
<!-- Add your space complexity here, e.g. $$O(n)$$ -->

# Code
```
class Solution {
    public List<String> letterCombinations(String digits) {
        
        if( digits.isEmpty() ){
            return new ArrayList<>();
        }
        List<String> ans = new ArrayList<>();
        recurseLetterCombine( digits, 0, new StringBuilder(), ans);
        return ans;
    }

    static String[] digitTochar = { "", "", "abc", "def", "ghi", "jkl", "mno", "pqrs", "tuv", "wxyz" }; // it stores the keypad in array form
                                  // each index correponds to respective possible characters

    static void recurseLetterCombine( String digits, int i, StringBuilder s, List<String> ans){

        if( i == digits.length() ){       // when size reached then add to answer 
            ans.add( s.toString() );
            return;
        }
        for( char c : digitTochar[ digits.charAt(i) - '0' ].toCharArray() ){    // initially start from first digit : so i = 0
            s.append( c);                                  // add current char to build string
            recurseLetterCombine( digits, i + 1, s, ans);  // now  recurse until our typed characters size equals desired digit size
            s.deleteCharAt( s.length() - 1);               // remove last character(way) to look for another way       
        }
    }


}
```